# WorldTimeSrt.py

The `WorldTimeSrt.py` script associates an event in a video file with a known standard time (in `hh:mm:ss` format) and creates a matching subtitle (`.srt`) file.  

This is useful when you want to align events in a video (e.g., flight telemetry, takeoff points) with real-world time references.

---

## Core Function

The main functionality is provided by:

```python
def generate_srt(video_path, interval, ref_video_seconds, ref_real_time):
Input Parameters
video_path – Path to the video file.

interval – Subtitle interval in integer seconds (e.g., 1).

ref_video_seconds – The time (in integer seconds from the start of the video) at which the reference event occurs.

ref_real_time – The actual real-world time of the event in hh:mm:ss format.

Example: Using OpenTX telemetry timestamps, a throttle burst or altitude change at takeoff can serve as a reference point that is visible or audible in the video.

Output
The script produces a subtitle file in the same folder as the video, with the video’s root name and the suffix _timeofday.srt.

Example:

Video:  DJIG0828.mp4  
Output: DJIG0828_timeofday.srt